(function () {
  "use strict";

  const { createElement: el } = wp.element;
  const { __ } = wp.i18n;

  function StatItem({ value, label }) {
    return el(
      "div",
      { className: "stat-item" },
      el("span", { className: "stat-value" }, value),
      el("span", { className: "stat-label" }, label)
    );
  }

  function StatsBar({ stats }) {
    return el(
      "div",
      { className: "vidtoarticle-stats-bar" },
      el(StatItem, {
        value: stats.total_published || 0,
        label: __("Published", "vidtoarticle-publisher"),
      }),
      el(StatItem, {
        value: stats.pending || 0,
        label: __("Pending", "vidtoarticle-publisher"),
      }),
      el(StatItem, {
        value: stats.failed || 0,
        label: __("Failed", "vidtoarticle-publisher"),
      }),
      el(StatItem, {
        value: stats.active_sources || 0,
        label: __("Active Sources", "vidtoarticle-publisher"),
      })
    );
  }

  window.VidToArticleComponents = window.VidToArticleComponents || {};
  window.VidToArticleComponents.StatsBar = StatsBar;
})();
