# Changelog

All notable changes to VidToArticle Auto Publisher will be documented in this file.

## [1.11.0] - 2026-02-20

### Fixed 🐛

- **Duplicate Article Prevention**: Added video-level deduplication using `_vidtoarticle_video_id` post meta
  - Prevents duplicate posts even when webhooks are delivered multiple times with different job IDs
  - Checks all post statuses (publish, draft, pending, private) before creating a new post
- **TAGS Line Leaking into Content**: Fixed regex to strip markdown-formatted TAGS lines
  - Now handles LLM outputs like `**TAGS:** tag1, tag2` or `- *Tags:* tag1`
  - Both extraction and removal regex now strip markdown formatting before matching
- **Markdown Rendering**: Bundled Parsedown 1.7.4 for proper markdown-to-HTML conversion
  - Replaces basic regex that failed on blockquotes, lists, code blocks, and combined formatting
  - Industry-standard parser handles all markdown syntax correctly
  - TAGS lines are also stripped before conversion as a safety net

### Improved ✨

- **Featured Image Fallback**: Image service now falls back to global Unsplash API key from `.env`
  - Users without per-user Unsplash keys still get proper featured images
  - Only tracks last-used timestamp when using per-user keys

### Technical Details

- `class-post-publisher.php`: Added `get_posts()` meta query for `_vidtoarticle_video_id` dedup check
- `article-formatter.ts`: `extractTags()` and `removeTagsSection()` strip markdown before matching
- `vendor/Parsedown.php`: Bundled Parsedown 1.7.4 (MIT license, single-file library)
- `vidtoarticle-publisher.php`: Auto-loads Parsedown on plugin init
- `image-service.ts`: Falls back to `Config.unsplashAccessKey` when no per-user key exists

## [1.10.0] - 2026-02-18

### Fixed 🐛

- **Duplicate Title Prevention**: Article title no longer appears twice in published posts
  - Plugin now strips the leading markdown H1 from article content before creating the WordPress post
  - WordPress `post_title` is the single source of truth for the title
- **Category & Author Assignment**: Posts now correctly receive the category and author configured on the source
  - Backend webhook delivery now passes `wp_category_id` and `wp_author_id` from source settings in the metadata payload
  - Plugin applies these when creating posts via `post_category` and `post_author`

### Improved ✨

- **Tag Fallback Generation**: Articles now always have tags, even when the AI model omits them
  - Added `generateTagsFromTitle()` fallback that extracts meaningful keywords from the article title
  - Filters out common stop words and short words for high-quality tag suggestions
  - Ensures a minimum of 3 tags per article

### Technical Details

- `class-post-publisher.php`: Added `preg_replace` to strip leading `# Title` before `convert_markdown_to_html()`
- `wordpress-webhook-delivery.ts`: Reads `source.settings.wpCategory`/`wpAuthor` and includes them in webhook metadata
- `article-formatter.ts`: New `generateTagsFromTitle()` method as fallback when `extractTags()` returns empty

## [1.9.1] - 2026-02-05

### Fixed 🐛

- **Disconnect Sync**: Plugin now automatically disconnects when user disconnects from VidToArticle.com dashboard
  - Backend sends HMAC-signed disconnect notification to WordPress plugin
  - No more manual disconnect needed from WordPress admin
- **Dashboard URL**: "Open Dashboard" button now redirects to `/wordpress-connect` page instead of generic dashboard

## [1.9.0] - 2026-02-05

### Added 🎉

- **Centralized Logs Dashboard**: View all logs in one place within WordPress admin
  - New "Backend Logs" tab showing webhook delivery history and job processing from VidToArticle.com
  - New "Plugin Logs" tab showing local WordPress plugin activity
  - Filter logs by level: Error, Warning, Info, Debug, or All
  - Auto-refresh toggle (30-second interval) for real-time monitoring
  - Color-coded log level badges for quick visual identification
  - Expandable details showing full context for each log entry

### Technical Details

- New backend endpoint `GET /api/wordpress/logs` with HMAC authentication
- WordPress REST route `/admin/backend-logs` proxies to backend
- Updated Activity Tab UI with React components for log display
- CSS improvements for log navigation and badge styling

### Why This Matters

- **Simplified Debugging**: No need to check server logs separately
- **Real-time Visibility**: See webhook failures and job errors immediately
- **Single Source of Truth**: All relevant logs visible in WordPress dashboard
- **Faster Troubleshooting**: Filter by error level to find issues quickly

## [1.8.0] - 2026-01-28

### Changed ✨

- **Simplified Plugin Interface**: The WordPress plugin is now a lightweight connector
  - Removed "Monitored Sources" tab - configure sources on VidToArticle.com
  - Removed "Article Queue" tab - monitor queue on VidToArticle.com
  - Removed Stats Bar - view detailed statistics on VidToArticle.com
  - Kept "Connection" and "Activity Log" tabs for essential plugin functionality
  - Added prominent "Open Dashboard" button to VidToArticle.com for configuration

### Why This Matters

- **Centralized Management**: All source configuration, article styles, and publishing settings are now managed on VidToArticle.com
- **Simpler WordPress Plugin**: WordPress plugin focuses on what it does best - connecting and publishing
- **Better User Experience**: No need to switch between WordPress and VidToArticle.com for configuration
- **Reduced Plugin Complexity**: Smaller codebase, faster loading, easier maintenance

### Technical Details

- Removed script enqueues for `sources-tab.js`, `queue-tab.js`, and `StatsBar.js`
- Simplified localized script data (removed styles, categories, authors)
- Added `siteUrl` and `dashboardUrl` to localized data
- Updated CSS with modern gradient header and connection status indicator
- Refactored `admin.js` to use configuration-driven tab rendering
- Connection tab now shows CTA button to VidToArticle.com dashboard

## [1.7.5] - 2026-01-28

### Fixed 🐛

- **Critical: Health Check Authentication**: Fixed HMAC signature path mismatch causing 401 errors
  - WordPress `$request->get_route()` returns route without `/wp-json` prefix
  - Backend signs requests with full path including `/wp-json` prefix
  - Fixed by prepending `/wp-json` to route in HMAC verification
  - Connection status now correctly shows as "Connected" after authorization

## [1.7.4] - 2026-01-28

### Changed ✨

- **OAuth Flow Simplified**: Switched from popup-based to redirect-based OAuth
  - No more popup windows - authorization happens in the main browser window
  - More reliable: avoids popup blockers and cross-origin messaging issues
  - Better mobile compatibility
  - Simpler codebase: removed ~90 lines of popup/postMessage handling code

### Removed 🗑️

- Removed popup window logic from `connection-tab.js`
- Removed `postMessage` callback handling from `admin.js`

## [1.7.3] - 2026-01-28

### Fixed 🐛

- **Connection Status Auto-Refresh**: Fixed main window not updating after OAuth popup closes
  - Added fallback `refreshConnection()` call when popup closes
  - Handles cases where `postMessage` is blocked by browser Cross-Origin-Opener-Policy
  - Connection status now updates automatically without requiring manual page refresh

## [1.7.2] - 2026-01-27

### Fixed 🐛

- **Admin Menu Icon**: Fixed oversized icon by using WordPress dashicons instead of custom SVG
  - Uses native `dashicons-video-alt3` icon which is guaranteed to work correctly
  - Eliminates all icon rendering issues across different WordPress versions and themes

## [1.7.1] - 2026-01-27

### Fixed 🐛

- **Admin Menu Icon**: Fixed oversized icon displaying in WordPress admin menu
  - Changed from URL-based SVG to base64-encoded data URI for proper rendering
  - WordPress requires icons to be dashicons, base64 data URIs, or 'none' - using a plain URL caused display issues
  - Icon now properly scales to 20x20px in the admin sidebar
  - Uses simplified monochrome design that adapts to WordPress admin color schemes

## [1.7.0] - 2025-11-28

### Added 🎉

- **Connection Health Check Endpoint**: New REST API endpoint `/health` for verifying plugin status
  - Returns plugin version, WordPress version, site name, and connection status
  - HMAC authenticated for security
  - Enables VidToArticle.com to verify plugin is installed and responding
  - Supports real-time connection status monitoring in the dashboard

### Technical Details

- Added `VIDTOARTICLE_PLUGIN_FILE` constant for proper plugin data retrieval
- Health endpoint returns structured JSON with `success`, `status`, `connected`, `plugin_version`, `wordpress_version`, `site_name`, and `timestamp` fields
- Integrated with existing HMAC signature verification for secure communication
- Backend now performs periodic health checks to detect plugin removal or deactivation
- Dashboard displays accurate connection status instead of assuming all sites are connected

### Why This Matters

- **Accurate Status Display**: Dashboard now shows actual connection status (Connected, Unreachable, Plugin Not Found, Auth Failed)
- **Proactive Issue Detection**: Users are notified when their WordPress plugin is missing or misconfigured
- **Better Troubleshooting**: Clear error messages help users understand and fix connection issues
- **Improved Reliability**: Prevents automation failures by detecting broken connections early

## [1.6.6] - 2025-11-20

### Changed ✨

- **Admin Experience**: Replaced default dashicon with branded SVG icon in wp-admin menu
  - Ensures VidToArticle Publisher entry visually matches main product branding
  - Uses existing high-resolution SVG asset bundled with the plugin for crisp rendering

## [1.6.5] - 2025-11-20

### Fixed 🐛

- **Source Management**: Updated REST API route regex to accept alphanumeric source IDs
  - Resolves `rest_no_route` errors when deleting sources created from YouTube usernames or custom IDs
  - Ensures PUT/DELETE operations work for all valid source identifiers without reloading sources first

## [1.6.4] - 2025-11-20

### Fixed 🐛

- **Authentication Error Handling**: Fixed issue where plugin would log authentication errors when not connected
  - Added authentication check in `get_sources()` method before making API calls
  - Plugin now gracefully returns empty sources array when not authenticated
  - Eliminates spurious 401 errors in activity log when plugin is not yet connected
  - Improves user experience by preventing error messages during initial setup

## [1.6.3] - 2025-11-20

### Added 🎉

- **Proper Uninstallation Procedure**: Comprehensive `uninstall.php` following WordPress best practices
  - Complete data cleanup when plugin is deleted via WordPress admin
  - Removes all database tables (sources, jobs, activity logs)
  - Deletes all plugin options and transients
  - Clears scheduled cron jobs
  - Removes all post meta created by the plugin
  - Multisite compatible with proper site transient cleanup

### Security 🔒

- Triple-layered security checks in uninstaller:
  - `WP_UNINSTALL_PLUGIN` constant verification
  - `ABSPATH` direct access prevention
  - User capability verification (`activate_plugins`)
- SQL injection prevention with prepared statements
- Proper escaping for all database operations

### Technical Details

- Structured function-based approach for maintainability
- Comprehensive logging when `WP_DEBUG_LOG` is enabled
- Cache flushing after cleanup
- WordPress Coding Standards compliant
- Zero database bloat after plugin removal
- Cleans 16 types of post meta from posts and attachments
- Pattern-based cleanup for dynamic transient keys (idempotency cache)

## [1.6.2] - 2025-11-19

### Changed 🔄

- Refactored the WordPress admin React bundle into modular components (StatsBar + individual tab chunks) for better maintainability and <600 line main file
- Added a global registry + lightweight loader that retries chunk registration and surfaces friendly notices if a module fails to initialize
- Updated asset enqueueing to load the new chunk files before `admin.js`, ensuring consistent dependency ordering and cache busting via `VIDTOARTICLE_VERSION`

### Fixed 🐛

- Added fallback UI when admin chunks fail to load and improved error notices for REST failures, reducing blank-screen scenarios in wp-admin

## [1.6.1] - 2025-11-13

### Fixed 🐛

- **CRITICAL**: Prevent duplicate article publishing when fallback poller processes the same job multiple times
- Add duplicate detection in `publish_article()` method to check if job already has a `post_id`
- Add logging for duplicate detection events (`fallback_duplicate_detected`)

### Technical Details

- Race condition occurred when WordPress polled `/missed-jobs` before webhook confirmation was processed
- Fallback poller now has same duplicate protection as webhook listener
- Jobs return `already_published: true` flag when duplicate is detected
- Backend: Add 5-minute grace period for recently-sent webhooks in `/missed-jobs` endpoint

## [1.6.0] - 2025-11-11

### 🔒 Security & Reliability - Production-Grade Release

This is a major reliability release addressing critical duplicate article issues and implementing enterprise-grade duplicate prevention.

### Fixed 🐛

- **CRITICAL**: Fixed infinite webhook loop causing 30+ duplicate article publishes
- **CRITICAL**: Fixed race conditions in cluster mode causing duplicate job processing
- Fixed missing webhook confirmation tracking
- Fixed check-then-act race conditions in job creation

### Added 🎉

- **Idempotency Protection**: WordPress transient-based cache prevents duplicate webhook processing
  - Fast path check before signature verification
  - 7-day automatic cache expiration
  - Returns existing post_id for duplicate webhooks
- **Idempotency Key Header**: `X-VidToArticle-Idempotency-Key` for request deduplication
- **Enhanced Security**:
  - Input sanitization for all webhook headers
  - Timing-safe signature comparison
  - Comprehensive audit logging for duplicate detection
- **Backend Improvements** (requires backend deployment):
  - Atomic job creation with deterministic IDs
  - MongoDB transaction-based job claiming
  - Atomic webhook delivery with proper confirmation
  - Comprehensive error handling throughout

### Changed 🔄

- Webhook processing now checks idempotency cache before signature verification (performance)
- Enhanced logging with `webhook_duplicate_idempotency` action type
- Improved error messages and context logging

### Technical Details

- Production-grade atomic operations prevent all forms of duplicate articles
- Multi-layer duplicate prevention (backend + WordPress plugin)
- Backward compatible with older backend versions
- Zero performance impact - transients are fast
- Automatic cleanup via WordPress transient expiration

### Deployment Notes

⚠️ **IMPORTANT**: Deploy backend code first, then update WordPress plugin
📖 See `PRODUCTION_DEPLOYMENT.md` for complete deployment instructions

## [1.5.2] - 2025-11-10

### Added 🎉

- **Major Feature**: Automatic Featured Image Support
  - Automatically fetches relevant images from Pexels and Unsplash during article generation
  - Users can configure their own API keys in VidToArticle.com settings
  - Images are downloaded and set as WordPress featured images with proper attribution
  - Optional feature - articles work normally without API keys
  - Secure per-user API key storage in MongoDB
  - Graceful fallback to YouTube thumbnails if no API images available

### New Files

- `includes/class-featured-image-handler.php` - Handles image download and attribution
- Settings UI in VidToArticle.com frontend for API key management
- Backend image service with Pexels/Unsplash integration

### Technical

- Updated article metadata to support featuredImage field
- Enhanced WordPress post publisher to prioritize API images over YouTube thumbnails
- Added secure backend validation for user settings
- Comprehensive error handling and logging
- Image validation and security checks

## [1.5.1] - 2025-11-10

### Fixed

- Fixed metadata separation issues in article processing

## [1.4.8] - 2025-11-09

### Fixed

- **Critical**: Fixed sources not appearing in list after creation
  - Added local duplicate check before calling backend API
  - When backend reports duplicate, sync it to local database instead of deleting
  - Prevents source from being lost when backend already has it
  - Source now appears in sources list immediately after creation
  - Fixes "No sources configured yet" showing when sources exist in backend

## [1.4.7] - 2025-11-09

### Added

- **Debug logging**: Added console.log statements to sources loading for troubleshooting
  - Logs full API response when loading sources
  - Logs sources array and count
  - Helps diagnose why sources list might appear empty

## [1.4.6] - 2025-11-09

### Fixed

- **Critical**: Disconnect now works even without valid HMAC credentials
  - Gracefully handles API revoke failure and still clears local data
  - Ensures disconnect always succeeds for the user
  - Added error logging for API revoke failures
  - Fixed order: use secret for HMAC before deleting it

## [1.4.5] - 2025-11-09

### Fixed

- **Disconnect button**: Fixed REST API disconnect not working properly
  - Removed dependency on POST nonce (REST API uses X-WP-Nonce header)
  - Disconnect now properly clears connection status and calls backend revoke endpoint
  - UI properly refreshes to show "Not Connected" after disconnect

## [1.4.4] - 2025-11-09

### Fixed

- **Critical**: Fixed 500 error when loading sources page
  - Changed `list_sources()` to `get_sources()` to match actual method name
  - Fixed `create_source()` method signature mismatch
  - API handler was calling with individual parameters, but source manager expects array
- **Critical**: Fixed "Missing required field: source_type" error when adding sources
  - Added YouTube URL parsing to extract playlist/channel IDs
  - Properly pass source data as array to source manager
  - Support for all YouTube URL formats (playlist, channel, @username, /c/, /user/)

### Added

- Helper method `extract_youtube_id()` to parse YouTube URLs
- Supports playlist URLs: `youtube.com/playlist?list=PLxxxxxx`
- Supports channel URLs: `youtube.com/channel/UCxxxxxx`, `youtube.com/@username`, `youtube.com/c/name`, `youtube.com/user/name`

## [1.4.3] - 2025-11-09

### Fixed

- **Backwards compatibility**: HMAC middleware now handles both old (keyHash) and new (secretKey) API keys
- Better error logging for source loading and creation failures
- Show actual error messages instead of generic "Failed to load sources"

### Improved

- Added console.error logging for debugging API issues
- Better user feedback when adding sources

## [1.4.2] - 2025-11-09

### Fixed

- **Critical**: Fixed HMAC authentication completely broken
  - Backend was trying to verify HMAC against bcrypt hash instead of actual secret
  - Changed storage from `keyHash` (bcrypt) to `secretKey` (plaintext) for HMAC verification
  - HMAC requires the actual secret key, not a hash
  - This allows status endpoint and all authenticated API calls to work properly
- Improved popup closure detection with 1-second delay for token exchange to complete
- Added success notification when connection completes

### Security Note

- Secret keys are now stored in plaintext in MongoDB (required for HMAC)
- Keys are only transmitted once over HTTPS during OAuth exchange
- Backend access controls restrict access to apiKeys collection

## [1.4.1] - 2025-11-09

### Fixed

- **Critical**: Fixed token exchange failing to save connection
  - Token exchange was incorrectly trying to use HMAC authentication
  - Created separate unauthenticated request method for token exchange
  - Secret key is now properly saved after OAuth authorization
  - Connection status now correctly shows as "Connected" after authorization

## [1.4.0] - 2025-11-09

### Added

- **OAuth 2.0 Security**: Implemented industry-standard security best practices
  - State parameter for CSRF protection (OAuth 2.0 RFC 6749 Section 10.12)
  - Random 32-character state value generated and validated
  - State stored in WordPress transient with 1-hour expiration
  - Prevents cross-site request forgery attacks

### Fixed

- **OAuth Callback Flow**: Fixed popup auto-close and status refresh
  - Backend now sends `oauth_callback=1` parameter
  - Backend sends `return_token` instead of `token` (matches plugin expectations)
  - Popup window now properly auto-closes after authorization
  - Main admin page automatically refreshes connection status
  - Fixed "Invalid security token" error by replacing nonce with state parameter

### Changed

- **Security Architecture**: Layered security approach
  - Removed inappropriate WordPress nonce check (can't validate external OAuth redirects)
  - Security now provided by: state parameter, one-time tokens, permission checks, token expiration
  - Maintained existing bcrypt hashing and HMAC authentication
  - Better error message for CSRF detection: "Invalid state parameter. This may be a CSRF attack."

## [1.3.1] - 2025-11-08

### Fixed

- **Critical**: Fixed OAuth endpoint URL
  - Changed from `/connect-wordpress` to `/api/wordpress/connect/initiate`
  - Backend now shows user-friendly HTML error pages instead of raw JSON
  - OAuth popup displays proper error messages and redirects to authorization page

### Changed

- **Backend API**: Updated to use correct WordPress integration endpoints
  - GET requests show HTML error pages for better UX
  - Redirects to frontend authorization page after validation
  - Proper error handling with styled error messages

## [1.3.0] - 2025-11-08

### Added

- **OAuth Popup Flow**: Connection now opens in popup window instead of redirecting entire page
  - Opens centered popup window (600x700px) for OAuth authorization
  - Detects when popup closes and automatically refreshes connection status
  - Shows success message in popup before auto-closing
  - Much better user experience - admin interface stays visible

### Changed

- **UX Improvement**: OAuth flow no longer shows raw JSON or redirects the admin page
  - User stays on admin page while OAuth happens in popup
  - No more confusing JSON error messages shown to users
  - Popup automatically closes after successful connection

### Technical Details

- Added OAuth callback detection via URL parameter `oauth_callback=1`
- Popup polls every 500ms to detect when user closes the window
- Connection status refreshes automatically when popup closes
- Follows WordPress plugin best practices for OAuth flows

## [1.2.6] - 2025-11-08

### Fixed

- **Critical**: Fixed REST API path construction issue
  - Removed `createRootURLMiddleware` usage which was interfering with default apiFetch behavior
  - Changed all API calls to use full paths: `/vidtoarticle/v1/admin/...`
  - WordPress apiFetch already has `/wp-json/` as default root, no need to override
  - REST API requests now work correctly without path mangling

### Technical Details

- `apiFetch` has built-in root URL of `/wp-json/`
- Using `createRootURLMiddleware` was replacing this with our namespace, causing incorrect paths
- Solution: Use full namespace paths in API calls, let apiFetch handle the rest
- URLs now correctly resolve to `/wp-json/vidtoarticle/v1/admin/...`

## [1.2.5] - 2025-11-08

### Fixed

- **Critical**: Fixed browser caching issue preventing JavaScript updates
  - Asset versions were hardcoded to `1.0.0` instead of using plugin version
  - Changed `wp_enqueue_script()` and `wp_enqueue_style()` to use `VIDTOARTICLE_VERSION`
  - Browser will now reload assets when plugin version changes
  - Fixes issue where updated JavaScript wasn't being loaded despite plugin update

### Technical Details

- Using dynamic version from constant ensures cache busting on updates
- URLs now include `?ver=1.2.5` instead of `?ver=1.0.0`
- This is WordPress best practice for asset versioning

## [1.2.4] - 2025-11-08

### Fixed

- **Critical**: Fixed duplicate namespace in REST API paths causing 404 errors
  - JavaScript was using `/vidtoarticle/v1/admin/connection` as path
  - But `apiFetch` root URL was already set to `vidtoarticle/v1`
  - This caused requests to `/wp-json/vidtoarticle/v1/vidtoarticle/v1/...` (404)
  - Changed all paths to use `/admin/...` (relative to configured root)
  - REST API now works correctly with proper authentication

### Technical Details

- The `createRootURLMiddleware` sets base path, so subsequent paths should be relative
- All `apiFetch()` calls now use paths relative to namespace (e.g., `/admin/connection`)
- Routes were always registered correctly; the issue was client-side URL construction

## [1.2.3] - 2025-11-08

### Added

- **Debug Logging**: Added comprehensive error logging to diagnose REST route registration issues
  - Logs when `register_rest_routes()` is called
  - Logs component initialization (API Handler, Webhook Listener)
  - Logs REST controller initialization and route registration
  - Helps identify why routes return 404 errors

### Technical Details

- All debug logs prefixed with `[VidToArticle]` for easy filtering
- Logs will appear in WordPress debug.log if `WP_DEBUG_LOG` is enabled
- Temporary debugging version to identify route registration failures

## [1.2.2] - 2025-11-08

### Fixed

- **Critical**: Fixed `is_connected()` method call in API Handler
  - Changed from `$this->oauth_handler->is_connected()` to `$this->api_client->is_connected()`
  - Same issue as v1.1.0 but in different file (class-api-handler.php:72)
  - Fixes Fatal error preventing REST API endpoints from working

## [1.2.1] - 2025-11-08

### Fixed

- **Critical**: Fixed REST API authentication issue (403 Cookie check failed)
  - Changed server-side API check to use internal dispatch instead of HTTP request
  - Configured `wp.apiFetch` with proper nonce middleware in JavaScript
  - Accept 403 as valid status code (indicates routes registered, auth will work from browser)
  - Proper nonce handling ensures REST endpoints authenticate correctly

### Changed

- **API Check Improvement**: Server-side REST API validation now uses `rest_get_server()->dispatch()`
  - More reliable than `wp_remote_get()` for internal checks
  - Avoids cookie/nonce issues in server-side context
  - 200, 401, or 403 status codes all indicate API is functional

### Technical Details

- JavaScript now properly configures nonce middleware: `apiFetch.use(apiFetch.createNonceMiddleware(nonce))`
- Server check accepts authentication errors as success (routes exist, browser auth will work)
- Fixes "Cookie check failed" error that showed after v1.2.0 deployment

## [1.2.0] - 2025-11-08

### Added

- **Server-Side Error Handling**: Plugin now shows helpful error message instead of blank screen
  - Displays clear instructions when REST API is unavailable
  - Checks REST API connectivity before loading React interface
  - Shows "Fix Permalinks" button for quick resolution
  - Provides technical details in expandable section for debugging
  - Follows WordPress admin UI best practices

### Changed

- **UX Improvement**: No more blank white screen under any circumstance
  - Always shows plugin header and title
  - Displays actionable error messages when API fails
  - Provides direct links to fix common issues (permalinks, etc.)
  - Better user experience following WordPress standards

### Technical Details

- Added `check_rest_api()` method to verify endpoint availability
- Server-side PHP renders error UI before React loads
- Accepts both 200 and 401 status codes (401 = routes registered, auth needed)
- Proper WordPress escaping and internationalization

## [1.1.3] - 2025-11-08

### Fixed

- **Critical**: Fixed WordPress hook timing issue causing REST routes not to register
  - `rest_api_init` fires before `plugins_loaded` completes
  - `register_rest_routes()` was being called before `$api_handler` was initialized
  - Added safety check to ensure components exist before registering routes
  - Routes now register correctly even if initialization order varies

### Technical Details

- WordPress hook execution order: `rest_api_init` can fire while `plugins_loaded` callbacks are still running
- Solution: Lazy initialization of required components in `register_rest_routes()`
- Ensures API Handler and Webhook Listener exist before passing to REST Controller
- Fixes blank admin screen and 404 errors on `/wp-json/vidtoarticle/v1/admin/*` endpoints

## [1.1.2] - 2025-11-08

### Fixed

- **Critical**: Fixed fatal error on plugin deactivation
  - Method name mismatch: deactivation hook was calling `deactivate()` but method was named `deactivation()`
  - Plugin can now be properly deactivated without PHP fatal errors
  - Error: "class VidToArticle_Publisher does not have a method 'deactivate'"

## [1.1.1] - 2025-11-08

### Fixed

- **Critical**: Fixed REST API routes not being registered due to context mismatch
  - Created dedicated `VidToArticle_API_Handler` class that always loads regardless of context
  - Separated REST API logic from admin UI class for proper WordPress architecture
  - Admin routes now work correctly because API handler loads in all contexts
  - This fixes the "No route was found matching the URL and request method" 404 errors
  - Plugin interface now displays properly with full API functionality

### Changed

- **Architecture Improvement**: Implemented WordPress best practices for REST API initialization
  - REST endpoints no longer depend on `is_admin()` context
  - API handler class always available for REST requests
  - Admin UI class now focused solely on rendering interface
  - Better separation of concerns between presentation and business logic

### Added

- `VidToArticle_API_Handler` class for handling all REST API endpoint logic
- `cancel_job()` method in Queue Manager for cancelling pending jobs

### Technical Details

- Fixed anti-pattern where UI would display but backend API was unavailable
- REST API requests don't run in admin context, so checking `is_admin()` prevented route registration
- New architecture ensures REST routes always register when `rest_api_init` hook fires
- Follows WordPress plugin development best practices for REST API integration

## [1.1.0] - 2025-11-08

### Added

- **Autoloader**: Implemented PSR-4 style autoloading for better performance
- **REST Controller**: Centralized REST API route registration
- **Logger Class**: Proper error logging with multiple log levels
- **Dependency Injection**: Admin and webhook components properly injected into REST controller

### Changed

- **Architecture**: Refactored main plugin class for better separation of concerns
- **REST API**: Fixed REST routes not registering properly (404 errors)
- **Code Organization**: Moved REST route registration to dedicated controller class
- **Performance**: Classes now loaded only when needed via autoloader

### Fixed

- **Critical**: Fixed `Call to undefined method is_connected()` error
  - Changed from `$this->oauth_handler->is_connected()` to `$this->api_client->is_connected()`
- **Critical**: Fixed 404 errors on REST API endpoints
  - Admin class now properly loads for REST requests
  - REST routes registered via dedicated controller instead of scattered registration
- **Performance**: Removed duplicate class loading
- **Best Practices**: Eliminated manual `require_once` statements in favor of autoloading

### Technical Details

- Implements WordPress plugin best practices
- Uses singleton pattern for logger
- Proper dependency injection throughout
- PSR-4 compatible autoloading
- Centralized error handling and logging

## [1.0.2] - 2025-11-08

### Fixed

- Fixed REST API routes not being registered when `is_admin()` returns false

## [1.0.1] - 2025-11-08

### Fixed

- Fixed method call bug in admin assets enqueue

## [1.0.0] - 2025-11-07

### Added

- Initial release
- OAuth-style connection to VidToArticle.com
- Automatic article publishing from YouTube playlists and channels
- Webhook-based real-time article delivery
- Fallback polling system
- Queue management for article publishing
- Activity logging
- WordPress admin interface
